// To parse this JSON data, do
//
//     final organizationListResponseModel = organizationListResponseModelFromJson(jsonString);

import 'dart:convert';

import 'package:viserpay/data/model/global/meassage_model.dart';
import 'package:viserpay/data/model/savings/savings_response_model.dart';

OrganizationListResponseModel organizationListResponseModelFromJson(String str) => OrganizationListResponseModel.fromJson(json.decode(str));

String organizationListResponseModelToJson(OrganizationListResponseModel data) => json.encode(data.toJson());

class OrganizationListResponseModel {
  final String? remark;
  final String? status;
  final Message? message;
  final Data? data;

  OrganizationListResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory OrganizationListResponseModel.fromJson(Map<String, dynamic> json) => OrganizationListResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null ? null : Message.fromJson(json["message"]),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message": message?.toJson(),
        "data": data?.toJson(),
      };
}

class Data {
  final List<SavingBank>? organizationList;
  final String? organizationImagePath;

  Data({this.organizationList, this.organizationImagePath});

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        organizationList: json["organizations"] == null ? [] : List<SavingBank>.from(json["organizations"]!.map((x) => SavingBank.fromJson(x))),
        organizationImagePath: json["organaization_image_path"],
      );

  Map<String, dynamic> toJson() => {
        "organizations": organizationList == null ? [] : List<dynamic>.from(organizationList!.map((x) => x.toJson())),
        "organization_image_path": organizationImagePath,
      };
}

class SavingBank {
  final String? id;
  final String? name;
  final String? image;
  final String? status;
  final String? createdAt;
  final String? updatedAt;
  final List<DpsPlan>? dpsPlans;

  SavingBank({
    this.id,
    this.name,
    this.image,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.dpsPlans,
  });

  factory SavingBank.fromJson(Map<String, dynamic> json) => SavingBank(
        id: json["id"].toString(),
        name: json["name"],
        image: json["image"],
        status: json["status"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        dpsPlans: json["dps_plans"] == null ? [] : List<DpsPlan>.from(json["dps_plans"]!.map((x) => DpsPlan.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "image": image,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "dps_plans": dpsPlans == null ? [] : List<dynamic>.from(dpsPlans!.map((x) => x.toJson())),
      };
}

class DpsPlan {
  final String? id;
  final String? organizationId;
  final String? savingTenureId;
  final String? savingIntervalId;
  final String? penaltyIntervalId;
  final String? installmentAmount;
  final String? interestRate;
  final String? penaltyRate;
  final String? maturityAmount;
  final String? status;
  final String? createdAt;
  final String? updatedAt;
  final Interval? interval; //info: interval for history
  final Interval? tenure; //info: interval for history
  final SavingBank? organization;

  DpsPlan({
    this.id,
    this.organizationId,
    this.savingTenureId,
    this.savingIntervalId,
    this.penaltyIntervalId,
    this.installmentAmount,
    this.interestRate,
    this.penaltyRate,
    this.maturityAmount,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.interval,
    this.tenure,
    this.organization,
  });

  factory DpsPlan.fromJson(Map<String, dynamic> json) => DpsPlan(
        id: json["id"].toString(),
        organizationId: json["organization_id"].toString(),
        savingTenureId: json["saving_tenure_id"].toString(),
        savingIntervalId: json["saving_interval_id"].toString(),
        penaltyIntervalId: json["penalty_interval_id"].toString(),
        installmentAmount: json["installment_amount"].toString(),
        interestRate: json["interest_rate"].toString(),
        penaltyRate: json["penalty_rate"].toString(),
        maturityAmount: json["maturity_amount"].toString(),
        status: json["status"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        tenure: json['saving_tenure'] == null ? null : Interval.fromJson(json['saving_tenure']),
        interval: json['saving_interval'] == null ? null : Interval.fromJson(json['saving_interval']),
        organization: json["organization"] == null ? null : SavingBank.fromJson(json["organization"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "organization_id": organizationId,
        "saving_tenure_id": savingTenureId,
        "saving_interval_id": savingIntervalId,
        "penalty_interval_id": penaltyIntervalId,
        "installment_amount": installmentAmount,
        "interest_rate": interestRate,
        "penalty_rate": penaltyRate,
        "maturity_amount": maturityAmount,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "saving_tenure": tenure,
        "saving_interval": interval,
      };
}
